/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.text.JTextComponent;

public class TextComponentPopupHandler
extends MouseAdapter {
    private static TextComponentPopupHandler INSTANCE;
    private ResourceBundle bundle = ResourceBundle.getBundle("com.pagosoft.plaf.Bundle");
    private Action cutAction = new CutAction();
    private Action copyAction = new CopyAction();
    private Action pasteAction = new PasteAction();
    private Action deleteAction = new DeleteAction();
    private Action selectAllAction = new SelectAllAction();
    private JPopupMenu popupMenu;
    private JTextComponent comp;

    public static TextComponentPopupHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TextComponentPopupHandler();
        }
        return INSTANCE;
    }

    private TextComponentPopupHandler() {
    }

    public ImageIcon getIcon(String string) {
        try {
            return new ImageIcon(TextComponentPopupHandler.class.getResource("/com/pagosoft/plaf/icons/" + string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger() || MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        this.comp = (JTextComponent)mouseEvent.getComponent();
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.cutAction);
        this.popupMenu.add(this.copyAction);
        this.popupMenu.add(this.pasteAction);
        this.popupMenu.add(this.deleteAction);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.selectAllAction);
        this.popupMenu.show(this.comp, mouseEvent.getX(), mouseEvent.getY());
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.selectall"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTextComponent)actionEvent.getSource()).selectAll();
        }

        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getText().length() > 0;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.delete"), TextComponentPopupHandler.this.getIcon("editdelete.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTextComponent)actionEvent.getSource()).replaceSelection(null);
        }

        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.paste"), TextComponentPopupHandler.this.getIcon("editpaste.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTextComponent)actionEvent.getSource()).paste();
        }

        public boolean isEnabled() {
            if (TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled()) {
                Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.copy"), TextComponentPopupHandler.this.getIcon("editcopy.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTextComponent)actionEvent.getSource()).copy();
        }

        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super(TextComponentPopupHandler.this.bundle.getString("textcomponent.cut"), TextComponentPopupHandler.this.getIcon("editcut.png"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTextComponent)actionEvent.getSource()).cut();
        }

        public boolean isEnabled() {
            return TextComponentPopupHandler.this.comp.isEditable() && TextComponentPopupHandler.this.comp.isEnabled() && TextComponentPopupHandler.this.comp.getSelectedText() != null;
        }
    }
}

