/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.jidesoft.utils.Lm;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;

public class PlafOptions {
    private static boolean vistaStyle;
    private static Dimension defIconSize;
    private static boolean useExtraMargin;
    private static boolean useBoldFonts;
    private static boolean useBoldMenuFonts;
    private static boolean useShadowBorder;
    private static boolean useToolBarIcon;
    private static boolean useDisabledIcon;
    private static boolean aaText;
    private static boolean isClearBorderEnabled;
    private static boolean fixHtmlDisplay;
    private static boolean wheelTabbedPaneEnabled;
    private static boolean tabbedPaneRightClickSelectionEnabled;
    private static boolean tabReorderingEnabled;
    private static boolean paintRolloverButtonBorder;
    private static boolean officeScrollBarEnabled;
    public static final int FLAT_STYLE = 0;
    public static final int GRADIENT_STYLE = 1;
    private static int defStyle;
    public static final String MENU_ITEM = "MenuItem";
    public static final String TOOLBAR = "ToolBar";
    public static final String BUTTON = "Button";
    public static final String TOOLBARBUTTON = "ToolBarButton";
    public static final String MENUBAR = "MenuBar";
    public static final String MENUBARMENU = "MenuBarMenu";
    private static HashMap styles;
    private static boolean fastGradient;

    private PlafOptions() {
    }

    public static void setAsLookAndFeel() {
        PgsLookAndFeel.setAsLookAndFeel();
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        PgsLookAndFeel.setCurrentTheme(metalTheme);
    }

    public static void updateAllUIs() {
        PgsLookAndFeel.updateAllUIs();
    }

    public static void setDefaultMenuItemIconSize(Dimension dimension) {
        defIconSize = dimension;
    }

    public static Dimension getDefaultMenuItemIconSize() {
        return defIconSize;
    }

    public static boolean useExtraMargin() {
        return useExtraMargin;
    }

    public static void useExtraMargin(boolean bl) {
        useExtraMargin = bl;
    }

    public static boolean useBoldFonts() {
        return useBoldFonts;
    }

    public static void useBoldFonts(boolean bl) {
        useBoldFonts = bl;
        UIManager.put("swing.boldMetal", bl);
    }

    public static boolean useBoldMenuFonts() {
        return useBoldMenuFonts;
    }

    public static void useBoldMenuFonts(boolean bl) {
        useBoldMenuFonts = bl;
    }

    public static void useShadowBorder(boolean bl) {
        useShadowBorder = bl;
    }

    public static boolean isShadowBorderUsed() {
        return useShadowBorder;
    }

    public static void useToolBarIcon(boolean bl) {
        useToolBarIcon = bl;
    }

    public static boolean isToolBarIconUsed() {
        return useToolBarIcon;
    }

    public static void useDisabledIcon(boolean bl) {
        useDisabledIcon = bl;
    }

    public static boolean isDisabledIconUsed() {
        return useDisabledIcon;
    }

    public static void setAntialiasingEnabled(boolean bl) {
        aaText = bl;
    }

    public static boolean isAntialiasingEnabled() {
        return aaText;
    }

    public static void setClearBorderEnabled(boolean bl) {
        PgsUtils.regenerateBorderStroke();
        isClearBorderEnabled = bl;
    }

    public static boolean isClearBorderEnabled() {
        return isClearBorderEnabled;
    }

    public static boolean isHtmlDisplayFixEnabled() {
        return fixHtmlDisplay;
    }

    public static void setFixHtmlDisplayEnabled(boolean bl) {
        fixHtmlDisplay = bl;
    }

    public static boolean isWheelTabbedPaneEnabled() {
        return wheelTabbedPaneEnabled;
    }

    public static void setWheelTabbedPaneEnabled(boolean bl) {
        wheelTabbedPaneEnabled = bl;
    }

    public static boolean isTabbedPaneRightClickSelectionEnabled() {
        return tabbedPaneRightClickSelectionEnabled;
    }

    public static void setTabbedPaneRightClickSelectionEnabled(boolean bl) {
        tabbedPaneRightClickSelectionEnabled = bl;
    }

    public static boolean isTabReorderingEnabled() {
        return tabReorderingEnabled;
    }

    public static void setTabReorderingEnabled(boolean bl) {
        tabReorderingEnabled = bl;
    }

    public static boolean isPaintRolloverButtonBorder() {
        return paintRolloverButtonBorder;
    }

    public static void setPaintRolloverButtonBorder(boolean bl) {
        paintRolloverButtonBorder = bl;
    }

    public static boolean isOfficeScrollBarEnabled() {
        return officeScrollBarEnabled;
    }

    public static void setOfficeScrollBarEnabled(boolean bl) {
        officeScrollBarEnabled = bl;
    }

    public static void setDefaultStyle(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The Style must be flat or gradient");
        }
        defStyle = n;
    }

    public static void setStyle(String string, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The Style must be flat or gradient");
        }
        styles.put(string, new Integer(n));
    }

    public static int getStyle(String string) {
        if (styles.containsKey(string)) {
            return (Integer)styles.get(string);
        }
        return defStyle;
    }

    public static Boolean isFlat(String string) {
        return PlafOptions.getStyle(string) == 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static void enableJideFastGradient() {
        Lm.verifyLicense((String)"Patrick Gotthardt", (String)"PgsLookAndFeel", (String)"aW6dEcgCQMkW4e:OGYJCDdPATGYEiLo2");
        fastGradient = true;
    }

    public static boolean isJideFastGradientEnabled() {
        return fastGradient;
    }

    public static boolean isVistaStyle() {
        return vistaStyle;
    }

    public static void setVistaStyle(boolean bl) {
        vistaStyle = bl;
    }

    static {
        defIconSize = new Dimension(10, 10);
        useExtraMargin = true;
        useBoldFonts = false;
        useBoldMenuFonts = true;
        useShadowBorder = false;
        useToolBarIcon = true;
        useDisabledIcon = true;
        aaText = false;
        isClearBorderEnabled = false;
        fixHtmlDisplay = true;
        wheelTabbedPaneEnabled = true;
        tabbedPaneRightClickSelectionEnabled = false;
        tabReorderingEnabled = false;
        paintRolloverButtonBorder = true;
        officeScrollBarEnabled = false;
        defStyle = 1;
        styles = new HashMap();
        PlafOptions.setStyle(MENU_ITEM, 0);
        PlafOptions.setStyle(MENUBAR, 0);
        PlafOptions.setStyle(MENUBARMENU, 0);
        PlafOptions.setStyle(TOOLBAR, 1);
        PlafOptions.setStyle(TOOLBARBUTTON, 1);
        fastGradient = false;
    }
}

