/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsScrollBarButton;
import com.pagosoft.plaf.PlafOptions;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class PgsScrollBarUI
extends MetalScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsScrollBarUI();
    }

    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        super.paintTrack(graphics, jComponent, rectangle);
        graphics.translate(rectangle.x, rectangle.y);
        if (((JScrollBar)jComponent).getOrientation() == 1) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.trackColor, rectangle.width, 0.0f, this.trackHighlightColor, true));
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.trackColor, 0.0f, rectangle.height, this.trackHighlightColor, true));
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        super.paintThumb(graphics, jComponent, rectangle);
        if (!jComponent.isEnabled()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        if (((JScrollBar)jComponent).getOrientation() == 1) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (PlafOptions.isOfficeScrollBarEnabled()) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, 0.0f, rectangle.height / 2 + 1, thumbColor, true));
                graphics2D.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, rectangle.width / 2 + 1, 0.0f, thumbColor, true));
                graphics2D.fillRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            }
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            int n = (int)rectangle.getWidth() / 2;
            int n2 = (int)rectangle.getHeight() / 2;
            boolean bl = rectangle.getHeight() <= 20.0;
            graphics.setColor(ColorUtils.getTranslucentColor(thumbShadow, 150));
            if (!bl) {
                graphics.drawLine(n - 3, n2 - 8, n + 3, n2 - 8);
            }
            graphics.drawLine(n - 3, n2 - 4, n + 3, n2 - 4);
            graphics.drawLine(n - 3, n2, n + 3, n2);
            graphics.drawLine(n - 3, n2 + 4, n + 3, n2 + 4);
            if (!bl) {
                graphics.drawLine(n - 3, n2 + 8, n + 3, n2 + 8);
            }
            graphics.setColor(ColorUtils.getTranslucentColor(thumbHighlightColor, 150));
            if (!bl) {
                graphics.drawLine(n - 2, n2 - 7, n + 4, n2 - 7);
            }
            graphics.drawLine(n - 2, n2 - 3, n + 4, n2 - 3);
            graphics.drawLine(n - 2, n2 + 1, n + 4, n2 + 1);
            graphics.drawLine(n - 2, n2 + 5, n + 4, n2 + 5);
            if (!bl) {
                graphics.drawLine(n - 2, n2 + 9, n + 4, n2 + 9);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (PlafOptions.isOfficeScrollBarEnabled()) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, rectangle.width / 2 + 1, 0.0f, thumbColor, true));
                graphics2D.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            } else {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, thumbHighlightColor, 0.0f, rectangle.height / 2 + 1, thumbColor, true));
                graphics2D.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            }
            graphics.setColor(thumbShadow);
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            graphics.drawLine(1, 1, rectangle.width - 3, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 3);
            int n = (int)rectangle.getWidth() / 2;
            int n3 = (int)rectangle.getHeight() / 2;
            boolean bl = rectangle.getWidth() <= 20.0;
            graphics.setColor(ColorUtils.getTranslucentColor(thumbShadow, 200));
            if (!bl) {
                graphics.drawLine(n - 8, n3 - 3, n - 8, n3 + 3);
            }
            graphics.drawLine(n - 4, n3 - 3, n - 4, n3 + 3);
            graphics.drawLine(n, n3 - 3, n, n3 + 3);
            graphics.drawLine(n + 4, n3 - 3, n + 4, n3 + 3);
            if (!bl) {
                graphics.drawLine(n + 8, n3 - 3, n + 8, n3 + 3);
            }
            graphics.setColor(ColorUtils.getTranslucentColor(thumbHighlightColor, 200));
            if (!bl) {
                graphics.drawLine(n - 7, n3 - 2, n - 7, n3 + 4);
            }
            graphics.drawLine(n - 3, n3 - 2, n - 3, n3 + 4);
            graphics.drawLine(n + 1, n3 - 2, n + 1, n3 + 4);
            graphics.drawLine(n + 5, n3 - 2, n + 5, n3 + 4);
            if (!bl) {
                graphics.drawLine(n + 9, n3 - 2, n + 9, n3 + 4);
            }
        }
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new PgsScrollBarButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new PgsScrollBarButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }
}

